/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.ammobench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCount;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCountType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class SetRangeOutputCount
implements AmmoBenchOutputCount {
    private static final Random RANDOM = new Random();
    private final int min;
    private final int max;

    public SetRangeOutputCount(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public int getCount(int count) {
        if (this.max - this.min < 1) {
            return this.min;
        }
        return this.min + RANDOM.nextInt(this.max - this.min + 1);
    }

    @Override
    public AmmoBenchOutputCountType<?> getType() {
        return AmmoBenchOutputCountType.SET;
    }

    public static final class Serializer
    implements AmmoBenchOutputCountType.AmmoBenchOutputCountSerializer<SetRangeOutputCount> {
        @Override
        public SetRangeOutputCount parseJson(JsonElement element) throws JsonParseException {
            int max;
            JsonObject object = JsonHelper.asJsonObject(element);
            int min = JSONUtils.func_151203_m((JsonObject)object, (String)"min");
            if (min > (max = JSONUtils.func_151208_a((JsonObject)object, (String)"max", (int)min))) {
                throw new JsonSyntaxException(String.format("Min value cannot be larger than max value - Min: %d, Max: %d", min, max));
            }
            return new SetRangeOutputCount(min, max);
        }

        @Override
        public void toNetwork(SetRangeOutputCount setRangeOutputCount, PacketBuffer buffer) {
            buffer.writeInt(setRangeOutputCount.min);
            buffer.writeInt(setRangeOutputCount.max);
        }

        @Override
        public SetRangeOutputCount fromNetwork(PacketBuffer buffer) {
            int min = buffer.readInt();
            int max = buffer.readInt();
            return new SetRangeOutputCount(min, max);
        }

        @Override
        public CompoundNBT toNbt(SetRangeOutputCount setRangeOutputCount) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("min", setRangeOutputCount.min);
            nbt.func_74768_a("max", setRangeOutputCount.max);
            return nbt;
        }

        @Override
        public SetRangeOutputCount fromNbt(CompoundNBT nbt) {
            int min = nbt.func_74762_e("min");
            int max = nbt.func_74762_e("max");
            return new SetRangeOutputCount(min, max);
        }
    }
}

